<?php
#----------------------------------------------------------#
# baseball_online _config.php
#----------------------------------------------------------#
# 環境設定
#----------------------------------------------------------#
define('DB_HOST','127.0.0.1');
define('DB_NAME','baseball_online');
define('DB_USER','root');
define('DB_PASS','');
#----------------------------------------------------------#
# CRYPT
#----------------------------------------------------------#
$SET['crypt']='bs';
#----------------------------------------------------------#
# ディレクトリ設定
#----------------------------------------------------------#
$SET['dir_data']='./data';
$SET['dir_mente']=$SET['dir_data'].'/mente';
$SET['dir_img']='./img';
$SET['dir_icon']=$SET['dir_img'].'/icon';
#----------------------------------------------------------#
# ファイルパス設定
#----------------------------------------------------------#
$SET['path_index']='./index.php';
$SET['path_admin']='./admin.php';
#----------------------------------------------------------#
# 画像大きさ設定
#----------------------------------------------------------#
$SET['icon_h_m']=17;
$SET['icon_h']=48;
$SET['flag_h']=71;
#----------------------------------------------------------#
# ゲーム設定
#----------------------------------------------------------#
#枚数
$SET['pl_cardnum']=100;					#カード最大所持枚数
$SET['pl_reg']=28;						#最大登録選手数
#ポイント
$SET['pl_cardpoint']=100;				#ノーマルカード1枚に必要なポイント
$SET['pl_cardpoint_sel']=200;				#ノーマル（選択）
$SET['pl_cardpoint_del']=30;				#破棄時に得るポイント
#勝敗
$SET['gm_pt_win']=100;					#勝った時のポイント
$SET['gm_pt_lose']=150;					#負
$SET['gm_pt_draw']=120;				#分
#時間
$SET['gm_num_max']=54;				#最大試合数
$SET['gm_itv']=3600*12;					#試合間隔
$SET['gm_itv_p']=300;					#最短試合間隔
$SET['gm_vac']=86400*3;				#シーズン休憩時間
#データ設定
$SET['dt_pcd_num']=28;
$SET['dt_btd_num']=24;
#----------------------------------------------------------#
# リスト設定
#----------------------------------------------------------#
#経験値
$SET[exp]=array(0,40,43,46,49,52,55,58,61,64,67,70,73,76,79,82,85,88,91,94,97,100,103,106,109,112,115,118,121,124,127,130,133,136,139,142,145,148,151,154,157,160,163,166,169,172,175,178,181,184,187,190,193,196,199,202,205,208,211,214,217,220,223,226,229,232,235,238,241,244,247,250,253,256,259,262,265,268,271,274,277,312,347,382,417,452,487,522,557,592,627,662,697,732,767,802,837,872,907,942,977);
#アイコンリスト
$SET[list_icon]=array(
'none.gif'
);
#'0.gif','1.gif','2.gif'....と追加できる
#チーム旗リスト
$SET[list_flag]=array(
'none.gif'
);
#'0.gif','1.gif','2.gif'....と追加できる
#レア等級
$SET[list_grade]=array(
'N'=>'<b style="color:black;" title="ノーマル">N</b>',
'R'=>'<b style="color:red;" title="レア">R</b>',
'HR'=>'<b style="color:goldenrod;" title="ハイレア">HR</b>',
'SR'=>'<b style="color:deeppink;" title="スーパーレア">SR</b>',
);
#投球フォーム
$SET[list_pstyle]=array(
'0'=>'<abbr title="オーバー">オーバー</abbr>',
'1'=>'<abbr title="スリークォーター">スリークォーター</abbr>',
'2'=>'<abbr title="サイド">サイド</abbr>',
'3'=>'<abbr title="アンダー">アンダー</abbr>',
'4'=>'<abbr title="アンダー2">アンダー2</abbr>',
);
#守備位置
$SET[list_pstyle_xy]=array(
'0'=>"27.35!124.44",
'1'=>"49.50!109.50",
'2'=>"70.00!60.00",
'3'=>"67.61!41.88",
'4'=>"49.50!10.50"
);
#球種
$SET[list_brk]=array('0'=>'ストレート','1'=>'スライダー','2'=>'カーブ','3'=>'フォーク','4'=>'シンカー','5'=>'シュート');
#守備位置
$SET[game_def]=array(
'1'=>'<b style="color:#ffffff;background-color:#f00000;">投</b>',
'2'=>'<b style="color:#ffffff;background-color:#a0a0f0;">捕</b>',
'3'=>'<b style="color:#ffffff;background-color:#e0ea00;">一</b>',
'4'=>'<b style="color:#ffffff;background-color:#e0ea00;">二</b>',
'5'=>'<b style="color:#ffffff;background-color:#e0ea00;">三</b>',
'6'=>'<b style="color:#ffffff;background-color:#e0ea00;">遊</b>',
'7'=>'<b style="color:#ffffff;background-color:#00f000;">左</b>',
'8'=>'<b style="color:#ffffff;background-color:#00f000;">中</b>',
'9'=>'<b style="color:#ffffff;background-color:#00f000;">右</b>'
);
$SET[game_def2]=array('1'=>'投','2'=>'捕','3'=>'一','4'=>'二','5'=>'三','6'=>'遊','7'=>'左','8'=>'中','9'=>'右');
$SET[game_def3]=array('1'=>'投手','2'=>'捕手','3'=>'一塁手','4'=>'二塁手','5'=>'三塁手','6'=>'遊撃手','7'=>'左翼手','8'=>'中堅手','9'=>'右翼手');
#----------------------------------------------------------#
# 表示
#----------------------------------------------------------#
function disp($html){
	print "-->\n";
	print $html;
}
#----------------------------------------------------------#
# エラー
#----------------------------------------------------------#
function error($html){
$disp.=head();
$disp.=html_bar();
$disp.=title(1);
$disp.=<<<EOF
<tr><td colspan=2>
<b>エラー</b><hr>
$html<br>
<a href="./index.php">トップに戻る</a>
</td></tr>
EOF;
$disp.=foot();
disp($disp);
exit();
}
#----------------------------------------------------------#
# MySQL接続/切断
#----------------------------------------------------------#
function sql_open(){
$db=mysql_connect(DB_HOST,DB_USER,DB_PASS) or error("mysql接続失敗");
mysql_select_db(DB_NAME,$db) or error("mysql(".DB_NAME.")接続失敗");
mysql_set_charset('utf8');
return $db;
}
function sql_close($db){
mysql_close($db) or error("mysql切断失敗");
}
#----------------------------------------------------------#
# データハッシュ#新規追加
#----------------------------------------------------------#
#データ
function insert_data($data){

foreach($data as $key=>$val){
	if($html){$html.=',';}
	$html.="'".$val."'";
}
$html='('.$html.')';
	return $html;
}
#カラム
function insert_colum($data){

foreach($data as $key=>$val){
	if($html){$html.=',';}
	$html.='`'.$key.'`';
}
$html='('.$html.')';
	return $html;
}
#----------------------------------------------------------#
# データハッシュ#更新
#----------------------------------------------------------#
function update_data($data,$none){
	foreach($data as $key=>$val){
		if($none != $key){
			if($html){$html.=',';}
			$html.='`'.$key.'`='."'$val'";
		}
	}
	if($data[0]){
		if($html){$html.=',';}
		$html.='`0`='."'$data[0]'";
	}
	return $html;
}
#----------------------------------------------------------#
# 更新用
#----------------------------------------------------------#
function update($table,$id,$data){
	if($table&&$id&&$data){
		$data_up=update_data($data,'id');
		mysql_query("UPDATE $table SET $data_up WHERE id='$id'");
	}
}
#----------------------------------------------------------#
# Include
#----------------------------------------------------------#
function read_file($file){
global $RF;
	if(!$RF[$file]){
		include $file;
		$RF[$file]=1;
	}
}
#----------------------------------------------------------#
# データ存在チェック
#----------------------------------------------------------#
function data_check($table,$ck_key,$ck_val){
	$sql=mysql_query("SELECT * FROM $table");
	if($sql){
		while($C=mysql_fetch_assoc($sql)){
			if($C[$ck_key] == $ck_val){
				return 1;
			}
		}
	}
	return 0;
}
#----------------------------------------------------------#
# IDチェック
#----------------------------------------------------------#
function check_id($id,$pass){
global$SET;
	if(!$id&&!$pass){error("クッキーが存在しません。");}
	$C=mysql_fetch_assoc(mysql_query("SELECT * FROM id WHERE id='$id'"));
	if(!$C[id]&&!$C[pass]){error("ID($id)が存在しません");}
	$pass=crypt($pass,$SET[crypt]);
	if($C[id] != $id||$C[pass] != $pass){error("Password($pass)が違います");}
}
#----------------------------------------------------------#
# データ取り出し
#----------------------------------------------------------#
function read_data($table,$id){
	$sql="SELECT * FROM $table WHERE id='$id'";
	$res=mysql_fetch_assoc(mysql_query($sql));
	return $res;
}
#----------------------------------------------------------#
# データ取り出し
#----------------------------------------------------------#
function read_dataL($table,$id){
	$sql="SELECT * FROM $table WHERE id='$id' FOR UPDATE";
	$res=mysql_fetch_assoc(mysql_query($sql));
	return $res;
}
#----------------------------------------------------------#
# カード枚数取り出し
#----------------------------------------------------------#
function read_cardnum($id){
	if($id){
		$sql="SELECT COUNT(*) as COUNT FROM player_card WHERE player_id='$id'";
		$row=mysql_fetch_assoc(mysql_query($sql));
		return $row[COUNT];
	}else{
		return 0;
	}
}
#----------------------------------------------------------#
# 画像パス設定
#----------------------------------------------------------#
function icon_url($data){
global $SET;
	if($data){
		$html_flag="$SET[dir_icon]/$data";
	}else{
		$html_flag="$SET[dir_icon]/none.gif";
	}
	return $html_flag;
}
#----------------------------------------------------------#
# ヘッド
#----------------------------------------------------------#
function head(){
global $RF,$SET;
	if(!$RF[head]){
$html=<<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="ja"><head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Style-Type" content="text/css">
<title>baseball online:監督視点の野球ゲーム</title>
<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1, maximum-scale=1">
<meta name="format-detection" content="telephone=no">
<link rel="stylesheet" href="./index.css" type="text/css">
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.1/jquery.min.js"></script>
<script type="text/javascript" src="./loading.js"></script>
<script type="text/javascript" src="./menu.js"></script>
<div id="loader"><img src="$SET[dir_img]/loading.png" width="128" height="128" alt="Loading..." /><br>Loading...</div>
<div id="fade"></div>
<div id="container">
EOF;
#$RF[head]=1;
return $html;
	}
#
}
#----------------------------------------------------------#
# スクロールバー
#----------------------------------------------------------#
function html_bar(){
global $Q,$SET;
#--------------------------------------#
# 携帯用css
#--------------------------------------#
if(!is_mobile()){
	$D[bar_width]='obj.w-520';
	$D[side_width]='520';
}else{
	$D[bar_width]='140';
	$D[side_width]='830';
}
#--------------------------------------#
$html.=<<<EOF
</head>
<body>
<!--SB STA-->
<div id="scroll_bar" style="position:fixed!important;top:0px;left:0px;width:100%;">
<table class="s_bar" width=100%><tr>
EOF;
if(!is_mobile()){
	$html.="<td id=\"logo\"><a href=\"$SET[path_index]\"><img src=\"./img/logo3.png\" style=\"width:15px;height:15px;\"><img src=\"./img/logo2.png\" style=\"width:91px;height:15px;\"></a></td>";
	$st_dd="dd";
	$st_sm="submenu";
}else{
	$st_dd="dd2";
	$st_sm="submenu2";
}
$html.="<td style=\"width:$D[side_width]px;\">\n";

#メニュー
if($_COOKIE[id]&&$_COOKIE[pass]){
if($Q[r]){$r_str="?r=$Q[r]";}
$html.=<<<EOF
<div id="$st_dd">
<li>
<a href="$SET[path_index]?r=team" class="menu" id="mmenu1"  onmouseover="mopen(1);" onmouseout="mclosetime();">一般</a>
<div class="$st_sm" id="menu1" onmouseover="mcancelclosetime()" onmouseout="mclosetime();">
<a href="$SET[path_index]?r=team_rank" style="border-width:1px 1px 1px 1px;">順位</a>
<a href="$SET[path_index]?r=game_result_pc">投手成績</a>
<a href="$SET[path_index]?r=game_result_bt">野手成績</a>
<a href="$SET[path_index]?r=card_draw">カードを引く</a>
<a href="$SET[path_index]?r=team_info">チーム情報</a>
<a href="$SET[path_index]?r=game_winner">歴代優勝チーム</a>
</div></li>
<li>
<a href="$SET[path_index]?r=team" class="menu" id="mmenu2" onmouseover="mopen(2);" onmouseout="mclosetime();">チーム</a>
<div class="$st_sm" id="menu2" onmouseover="mcancelclosetime()" onmouseout="mclosetime();">
<a href="$SET[path_index]?r=team_order" style="border-width:1px 1px 1px 1px;">オーダー設定</a>
<a href="$SET[path_index]?r=team_pitch">登板設定</a>
<a href="$SET[path_index]?r=card_list">カードリスト</a>
<a href="$SET[path_index]?r=team_reg">試合登録</a>
<a href="$SET[path_index]?r=team_result">チーム成績</a>
</div></li>
<li>
<a href="$SET[path_index]?r=team_game" class="menu" id="mmenu3" onmouseover="mopen(3);" onmouseout="mclosetime();">試合</a>
</li>
<li><a class="menu" id="mmenu4" onmouseover="mopen(4);" onmouseout="mclosetime();">その他</a>
<div class="$st_sm" id="menu4" onmouseover="mcancelclosetime()" onmouseout="mclosetime();">
<a href="$SET[path_index]?r=logout" style="border-width:1px 1px 1px 1px;">ログアウト</a>
<a href="$SET[path_index]">トップページ</a>
<!--<a href="$SET[path_mail]" target="_blank">メール#</a>-->
<a href="$SET[path_index]?r=document">資料室</a>
<a href="./manual/index.html" target="_blank">説明書</a>
<a href="$SET[path_index]?r=copyright">著作権等</a>
</div></li>
<li>
<a href="$SET[path_index]$r_str" class="menu" id="mmenu5" onmouseover="mopen(5);" onmouseout="mclosetime();">更新</a>
</li>
</div>
EOF;
}
#メニューEND
$html.=<<<EOF
</td></tr></table>
</div>
<!--SB END-->
EOF;
return $html;
}
#----------------------------------------------------------#
# タイトル
#----------------------------------------------------------#
function title($id){
global $SET,$Q;
#
$html.=<<<EOF
\n<div style="text-align:center;margin:auto;">
<!--TB STA-->\n
EOF;

if($id==1){

$html.=<<<EOF
<table class=tm2 align=center>
<tr><td colspan=2 class=tmt>
<a href="$SET[path_index]"><img src="$SET[dir_img]/logo.png" style="width:182px;height:75px;" alt="Baseball Online"></a><br>
</td></tr>
EOF;

}elseif($id=='game'){

$html.=<<<EOF
<table class=tm3 align=center>
<tr><td colspan=2 class=tmt>
<a href="$SET[path_index]"><img src="$SET[dir_img]/logo.png" style="width:182px;height:75px;" alt="Baseball Online"></a><br>
</td></tr>
EOF;

}elseif(!$id){

$html.=<<<EOF
<table class=tm align=center>
<tr><td colspan=2 class=tmt>
<a href="$SET[path_index]"><img src="$SET[dir_img]/logo.png" style="width:182px;height:75px;" alt="Baseball Online"></a><br>
</td></tr>
EOF;

}elseif(data_check('id','id',$id)){

$PL=read_data('player',$id);
$TM=read_data('team',$id);
$html_flag_url=icon_url($PL[5]);
$html_icon_url=icon_url($PL[6]);
$html_rank=set_rank($id);

$html.=<<<EOF
<table class=tm2 align=center>
<tr><td colspan=2 class=tmt>
<a href="$SET[path_index]"><img src="$SET[dir_img]/logo.png" style="width:182px;height:75px;" alt="Baseball Online" align=left></a><br>
<table><tr>
<td><img src="$html_flag_url" height=$SET[flag_h]></td><td><img src="$html_icon_url" height=$SET[icon_h]></td><td>
<font size="5">$PL[1]</font><br>
<font size="2"><font color=red>$html_rank</font>&nbsp;$TM[2]試合&nbsp;$TM[3]勝$TM[4]敗$TM[5]分<br>
カードP$PL[11]&nbsp;トレードP$PL[12]</font>
</td></tr></table>
</td></tr>
EOF;

}
	return $html;
}
#----------------------------------------------------------#
# フット
#----------------------------------------------------------#
function foot(){
global $RF,$TIME_ST;
#
	if(!$RF[foot]){
	$TIME_SET=floor((microtime(true)-$TIME_ST)*1000)/1000;
$html.=<<<EOF
<!--TB END-->
<tr><td colspan=2 class=tmu style="font-size:9pt;font-family:MS UI Gothic;text-align:right;"><a href='http://rei-farms.jp/' target='_blank'>baseball online</a>($TIME_SET CPUs)</td></tr></table>
</div>
</div>
</body></html>
EOF;
#$RF[foot]=1;
return $html;
	}
#
}
#----------------------------------------------------------#
# 調子表示
#----------------------------------------------------------#
function ch_tone($d){
	if($d>=80){
		$html="<img src=\"./img/y5.gif\" title=\"絶好調($d)\">";
	}elseif($d>=60){
		$html="<img src=\"./img/y4.gif\" title=\"好調($d)\">";
	}elseif($d>=40){
		$html="<img src=\"./img/y3.gif\" title=\"普通($d)\">";
	}elseif($d>=20){
		$html="<img src=\"./img/y2.gif\" title=\"不調($d)\">";
	}elseif($d>=0){
		$html="<img src=\"./img/y1.gif\" title=\"絶不調($d)\">";
	}else{
		$html="<img src=\"./img/yy.gif\" title=\"怪我\">";
	}
	return $html;
}
#----------------------------------------------------------#
# 疲労表示
#----------------------------------------------------------#
function ch_fati($d){
	if($d>=80){
		$html="<img src=\"./img/y1.gif\" title=\"疲労($d)\">";
	}elseif($d>=60){
		$html="<img src=\"./img/y2.gif\" title=\"不調($d)\">";
	}elseif($d>=40){
		$html="<img src=\"./img/y3.gif\" title=\"普通($d)\">";
	}elseif($d>=20){
		$html="<img src=\"./img/y4.gif\" title=\"好調($d)\">";
	}elseif($d>=0){
		$html="<img src=\"./img/y5.gif\" title=\"快調($d)\">";
	}else{
		$html="<img src=\"./img/yy.gif\" title=\"怪我\">";
	}
	return $html;
}
#----------------------------------------------------------#
# 打率/1000分率表示
#----------------------------------------------------------#
function AVE($d0,$d1){
	if($d0>0){
		$per=floor($d1/$d0*1000)/1000;
		if($per==0){$per="0.000";}
	}else{
		$per="0.000";
	}
	return $per;
}

function AVE2($d0){
	if($d0>0){
		$per=floor($d0*1000)/1000;
	}else{
		$per="0.000";
	}
	return $per;
}
#----------------------------------------------------------#
# 防御率
#----------------------------------------------------------#
function ERA($d0,$d1){
	if($d0>0){
		$era=floor(($d1*9)/($d0/3)*100)/100;
	}else{
		$era='-';
	}
	return $era;
}
#----------------------------------------------------------#
# WHIP
#----------------------------------------------------------#
function WHIP($d0,$d1){
	if($d0>0){
		$whip=floor($d1/($d0/3)*100)/100;
	}else{
		$whip='-';
	}
	return $whip;
}
#----------------------------------------------------------#
# ランダム出力(アイコン)
#----------------------------------------------------------#
function rand_icon(){
global $SET;
	$icon_num=count($SET[list_icon]);
	$icon_key=mt_rand(0,($icon_num-1));
	$html.=$SET[list_icon][$icon_key];
	return $html;
}
#----------------------------------------------------------#
# ランダム出力(名前)
#----------------------------------------------------------#
function rand_name(){
global $SET;

	#lastname(姓)
	$LN=fopen("$SET[dir_data]/list_lastname.pl",'r');
	$LNA=array();
	if($LN){
		$no=0;
		while (!feof($LN)){
			$LNA[$no]=str_replace(array("\r\n","\r","\n"), '',fgets($LN));
			$no++;
		}
		$ln_num=count($LNA);
		$ln_key=mt_rand(0,($ln_num-1));
		$html.=$LNA[$ln_key];
	}
	#firstname(名)
	$FN=fopen("$SET[dir_data]/list_firstname.pl",'r');
	$FNA=array();
	if($FN){
		$no=0;
		while (!feof($FN)){
			$FNA[$no]=str_replace(array("\r\n","\r","\n"), '',fgets($FN));
			$no++;
		}
		$fn_num=count($FNA);
		$fn_key=mt_rand(0,($fn_num-1));
		$html.=$FNA[$fn_key];	
	}
	fclose($FN);fclose($LN);
	return $html;
}
#----------------------------------------------------------#
# ステータス表示
#----------------------------------------------------------#
function ch_st($st,$no){
	if($st>=110){		$html='X';$color='teal';
	}elseif($st>=100){	$html='N';$color='black';
	}elseif($st>=90){	$html='U';$color='goldenrod';
	}elseif($st>=80){	$html='S';$color='deeppink';
	}elseif($st>=70){	$html='A';$color='lightcoral';
	}elseif($st>=60){	$html='B';$color='crimson';
	}elseif($st>=50){	$html='C';$color='gold';
	}elseif($st>=40){	$html='D';$color='green';
	}elseif($st>=30){	$html='E';$color='cornflowerblue';
	}elseif($st>=20){	$html='F';$color='blueviolet';
	}elseif($st>=10){	$html='G';$color='dimgray';
	}elseif($st>0){		$html='Z';$color='black';
	}else{			$html='-';$color='black';
	}
	#
	if(!$no){
		return "<b style='color:$color;'>$html</b>";
	}else{
		return "$html";
	}
}
#----------------------------------------------------------#
# 走力m/s
#----------------------------------------------------------#
function ch_st_sp($st){
	$sp=0.03*$st+5.5;
	#$sp=0.03*$st+6;
	return $sp;
}
#----------------------------------------------------------#
# 球速表示/最速
#----------------------------------------------------------#
function ch_psp($st,$tone){
	$sp=floor(0.8576*$st+0.08*$tone+3.24*(mt_rand(0,200)/100-1)+76.5);
	return $sp;
}
function ch_psp_max($st,$tone){
	$sp=floor(0.8576*$st+0.08*$tone+3.24+76.5);
	return $sp;
}
#------------------------------------------------#
# 投球回表示
#------------------------------------------------#
function ch_ptime($num){
	$pc_t1=floor($num/3);
	$pc_t2=$num%3;
	if($pc_t2==0){
		$html=$pc_t1."回";
	}else{
		$html=$pc_t1."回".$pc_t2."/3";
	}
	return $html;
}
#------------------------------------------------#
# STポイント取得
#------------------------------------------------#
function ch_st_pt($pt){
	$st=5/8*pow(($pt),2);
	return $st;
}
#------------------------------------------------#
# STポイント出力
#------------------------------------------------#
function ch_st_gt($pt){
	$st=floor(pow(2,(3/2))/5*sqrt(5*$pt)*100)/100;
	return $st;
}
#------------------------------------------------#
# 成長/サブ
#------------------------------------------------#
function ch_growth($CD){
	#野手
	$CD[11]=ch_growth2($CD[11],$CD[46]);
	$CD[12]=ch_growth2($CD[12],$CD[47]);
	$CD[13]=ch_growth2($CD[13],$CD[48]);
	$CD[14]=ch_growth2($CD[14],$CD[49]);
	$CD[15]=ch_growth2($CD[15],$CD[50]);
	$CD[16]=ch_growth2($CD[16],$CD[51]);
	$CD[17]=ch_growth2($CD[17],$CD[52]);
	#投手
	$CD[21]=ch_growth2($CD[21],$CD[53]);
	$CD[22]=ch_growth2($CD[22],$CD[54]);
	$CD[23]=ch_growth2($CD[23],$CD[55]);
	$CD[24]=ch_growth2($CD[24],$CD[56]);
	$CD[25]=ch_growth2($CD[25],$CD[57]);
	$CD[26]=ch_growth2($CD[26],$CD[58]);
	$CD[27]=ch_growth2($CD[27],$CD[59]);
	$CD[28]=ch_growth2($CD[28],$CD[60]);
	#出力
	return $CD;
}
#サブ計算
function ch_growth2($num1,$num2){
	$stp=ch_st_pt($num1);
	$st=ch_st_gt(($stp+$num2));
	return $st;
}
#----------------------------------------------------------#
# カード表示
#----------------------------------------------------------#
function ch_card($CD){
global $Q,$SET;
$html='';
	#--------------------------------------#
	# 共通出力
	#--------------------------------------#
	if($CD[1]=='B'){$CH_B='block';$CH_P='none';}else{$CH_B='none';$CH_P='block';}
	$CH_TONE=ch_tone($CD[4]);
	$CH_FATI=ch_fati($CD[5]);
	$CH_RARE=$SET[list_grade][$CD[37]];
	$CH_PS=$SET[list_pstyle][$CD[20]];
	$CH_PSP=ch_psp_max($CD[21],$CD[4]).'km/h';
	$CH_PSTY=$SET[list_pstyle][$CD[20]];
	$CH_NEXP=$SET[exp][$CD[7]]-$CD[8];
	$CH_NEXP='LvUPまであと'.$CH_NEXP.'exp必要です';
	#
	$CH[11]=ch_st($CD[11],0);$CH[12]=ch_st($CD[12],0);$CH[13]=ch_st($CD[13],0);$CH[14]=ch_st($CD[14],0);$CH[15]=ch_st($CD[15],0);$CH[16]=ch_st($CD[16],0);$CH[17]=ch_st($CD[17],0);
	$CH[21]=ch_st($CD[21],0);$CH[22]=ch_st($CD[22],0);$CH[23]=ch_st($CD[23],0);$CH[24]=ch_st($CD[24],0);$CH[25]=ch_st($CD[25],0);$CH[26]=ch_st($CD[26],0);$CH[27]=ch_st($CD[27],0);$CH[28]=ch_st($CD[28],0);
	$CH[31]=ch_st($CD[31],0);
	$CHL[21]=ch_st($CD[21],1);$CHL[24]=ch_st($CD[24],1);$CHL[25]=ch_st($CD[25],1);$CHL[26]=ch_st($CD[26],1);$CHL[27]=ch_st($CD[27],1);$CHL[28]=ch_st($CD[28],1);
	$CHL[31]=ch_st($CD[31],1);$CHL[32]=ch_st($CD[32],1);$CHL[33]=ch_st($CD[33],1);$CHL[34]=ch_st($CD[34],1);$CHL[35]=ch_st($CD[35],1);$CHL[36]=ch_st($CD[36],1);
	$CHF[11]=floor($CD[11]);$CHF[12]=floor($CD[12]);$CHF[13]=floor($CD[13]);$CHF[14]=floor($CD[14]);$CHF[15]=floor($CD[15]);$CHF[16]=floor($CD[16]);$CHF[17]=floor($CD[17]);
	$CHF[21]=floor($CD[21]);$CHF[22]=floor($CD[22]);$CHF[23]=floor($CD[23]);$CHF[24]=floor($CD[24]);$CHF[25]=floor($CD[25]);$CHF[26]=floor($CD[26]);$CHF[27]=floor($CD[27]);$CHF[28]=floor($CD[28]);
	$CHF[31]=floor($CD[31]);
	#変化量取得
	$CHBR1=ceil($CD[24]/(100/7));if($CHBR1>7){$CHBR1=7;}
	$CHBR2=ceil($CD[25]/(100/7));if($CHBR2>7){$CHBR2=7;}
	$CHBR3=ceil($CD[26]/(100/7));if($CHBR3>7){$CHBR3=7;}
	$CHBR4=ceil($CD[27]/(100/7));if($CHBR4>7){$CHBR4=7;}
	$CHBR5=ceil($CD[28]/(100/7));if($CHBR5>7){$CHBR5=7;}
if($CD[2]=='R'){
$html_brk=<<<EOF
<table style="text-align:center;font-size:11px;" align=center><tr style="vertical-align:top;">
<td rowspan=2 style="width:25px;">$CH[24]</td>
<td><img src='./img/brk1-$CHBR1.png' style="width:44px;height:10px;" alt='スライダー' title='スライダー$CHL[24]$CHF[24]($CHL[32]$CHF[32])'></td>
<td><img src='./img/brk0.png' style="width:10px;height:10px;" alt='ストレート' title='ストレート$CHL[21]$CHF[21]($CHL[31]$CHF[31])'></td>
<td><img src='./img/brk5-$CHBR5.png' style="width:44px;height:10px;" alt='シュート' title='シュート$CHL[28]$CHF[28]($CHL[36]$CHF[36])'></td>
<td rowspan=2 style="width:25px;">$CH[28]</td>
</tr><tr>
<td><img src='./img/brk2-$CHBR2.png' style="width:44px;height:44px;" alt='カーブ' title='カーブ$CHL[25]$CHF[25]($CHL[33]$CHF[33])'></td>
<td><img src='./img/brk3-$CHBR3.png' style="width:10px;height:44px;" alt='フォーク' title='フォーク$CHL[26]$CHF[26]($CHL[34]$CHF[34])'></td>
<td><img src='./img/brk4-$CHBR4.png' style="width:44px;height:44px;" alt='シンカー' title='シンカー$CHL[27]$CHF[27]($CHL[35]$CHF[35])'></td>
</tr><tr>
<td>$CH[25]</td><td></td><td>$CH[26]</td><td></td><td>$CH[27]</td>
</tr></table>
EOF;
}else{
$html_brk=<<<EOF
<table style="text-align:center;font-size:11px;" align=center><tr style="vertical-align:top;">
<td rowspan=2 style="width:25px;">$CH[28]</td>
<td><img src='./img/brk1-$CHBR5.png' style="width:44px;height:10px;" alt='シュート' title='シュート$CHL[28]$CHF[28]($CHL[36]$CHF[36])'></td>
<td><img src='./img/brk0.png' style="width:10px;height:10px;" alt='ストレート' title='ストレート$CHL[21]$CHF[21]($CHL[31]$CHF[31])'></td>
<td><img src='./img/brk5-$CHBR1.png' style="width:44px;height:10px;" alt='スライダー' title='スライダー$CHL[24]$CHF[24]($CHL[32]$CHF[32])'></td>
<td rowspan=2 style="width:25px;">$CH[24]</td>
</tr><tr>
<td><img src='./img/brk2-$CHBR4.png' style="width:44px;height:44px;" alt='シンカー' title='シンカー$CHL[27]$CHF[27]($CHL[35]$CHF[35])'></td>
<td><img src='./img/brk3-$CHBR3.png' style="width:10px;height:44px;" alt='フォーク' title='フォーク$CHL[26]$CHF[26]($CHL[34]$CHF[34])'></td>
<td><img src='./img/brk4-$CHBR2.png' style="width:44px;height:44px;" alt='カーブ' title='カーブ$CHL[25]$CHF[25]($CHL[33]$CHF[33])'></td>
</tr><tr>
<td>$CH[27]</td><td></td><td>$CH[26]</td><td></td><td>$CH[25]</td>
</tr></table>
EOF;
}

$html.=<<<EOF
<div id='$CD[id]'>
<table id='B$CD[id]' style="width:183px;height:251px;border:0px;background-image:url('$SET[dir_img]/card_bg_bt.png');font-family:Arial,'ＭＳ Ｐゴシック',sans-serif;font-size:16px;display:$CH_B;" onclick="document.getElementById('P$CD[id]').style.display='block';this.style.display='none';">
<tr style="height:24px;"><td style="font-size:16px;text-align:center;font-weight:bold;" colspan=5>$CD[0]</td><td style="width:48px;text-align:center;" colspan=2>$CH_TONE$CH_FATI</td></tr>
<tr style="text-align:center;"><td style="text-align:center;vertical-align:middle;" colspan=4 rowspan=4>
<img src="$SET[dir_icon]/$CD[6]" style="height:$SET[icon_h]px;" alt="image" title="$CD[0]">
</td><td style="height:21px;font-size:10px;" title="カードの等級">R</td><td colspan=2 style="font-size:11px;">$CH_RARE</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="利き腕">投</td><td style="font-size:11px;" colspan=2>$CD[2]</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="打席">打</td><td style="font-size:11px;" colspan=2>$CD[3]</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="レベル">Lv</td><td style="font-size:11px;" colspan=2 title="$CH_NEXP">$CD[7]</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" colspan=4>特能：-</td><td title="ステータスポイント">P</td><td style="font-size:11px;" colspan=2>$CD[45]</td></tr>
<tr style="height:21px;text-align:center;font-size:12px;"><td style="width:22px;" title="ミートさせる技術">巧</td><td style="width:22px;" title="打球を遠くへ飛ばす力">力</td><td style="width:22px;" title="足の速さ">走</td><td style="width:22px;" title="守備時の肩の強さ">肩</td><td style="width:21px;" title="守備の上手さ">守</td><td style="width:22px;" title="打球・投球に対する反応速度">反</td><td style="width:22px;" title="エラー発生率の低さ">E避</td></tr>
<tr style="height:23px;text-align:center;font-size:15px;"><td>$CH[11]</td><td>$CH[12]</td><td>$CH[13]</td><td>$CH[14]</td><td>$CH[15]</td><td>$CH[16]</td><td>$CH[17]</td></tr>
<tr style="height:20px;text-align:center;font-size:10px;"><td>$CHF[11]</td><td>$CHF[12]</td><td>$CHF[13]</td><td>$CHF[14]</td><td>$CHF[15]</td><td>$CHF[16]</td><td>$CHF[17]</td></tr>
<tr style="height:19px;font-size:8px;text-align:center;"><td colspan=7>&nbsp;</td></tr>
<tr style="font-size:9px;text-align:center;"><td colspan=7>ID:$CD[id]($CD[1])</td></tr>
</table>
<table id='P$CD[id]' style="width:183px;height:251px;border:0px;background-image:url('$SET[dir_img]/card_bg_pc.png');font-family:Arial,'ＭＳ Ｐゴシック',sans-serif;font-size:16px;display:$CH_P;" onclick="document.getElementById('B$CD[id]').style.display='block';this.style.display='none';">
<tr style="height:24px;"><td style="font-size:16px;text-align:center;font-weight:bold;" colspan=2>$CD[0]</td><td style="width:48px;text-align:center;">$CH_TONE$CH_FATI</td></tr>
<tr style="text-align:center;"><td style="text-align:center;vertical-align:middle;width:100px;" rowspan=4>
<img src="$SET[dir_icon]/$CD[6]" style="height:$SET[icon_h]px;" alt="image" title="$CD[0]">
</td><td style="width:21px;font-size:10px;" title="利き腕">投</td><td style="height:21px;font-size:11px;">$CD[2]</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="球速">速</td><td style="font-size:11px;" title="$CHL[21]$CHF[21]">$CH_PSP</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="速球キレ">速K</td><td style="font-size:11px;" title="$CHF[31]">$CH[31]</td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="コントロール">制</td><td style="font-size:11px;" title="$CHF[23]">$CH[22]</td></tr>
<tr style="font-size:9px;text-align:center;"><td style="height:21px;">$CH_PSTY</td><td title="スタミナ">体</td><td style="font-size:11px;" title="$CHF[23]">$CH[23]</td></tr>
<tr style="height:89px;text-align:center;font-size:9px;vertical-align:middle;"><td colspan=3>
$html_brk
</td></tr>
<tr style="font-size:9px;text-align:center;"><td colspan=3>ID:$CD[id]($CD[1])</td></tr>
</table>
</div>
EOF;
return $html;
}
#----------------------------------------------------------#
# カードフォーカス
#----------------------------------------------------------#
function ch_focus($ID){
global $CF,$SET;
#複数IDを可能に
$IDs=explode("!",$ID);
$IDC=array();#チェック用
#初期設定
$js_ch_num=0;$CF=array();
foreach($IDs as $num=>$ID){
	if($IDC[$ID]){continue;}
	#チェック
	$check=data_check('player','id',$ID);
	if($check){
		$sql=mysql_query("SELECT * FROM player_card WHERE player_id='$ID'");
		while ($CD=mysql_fetch_assoc($sql)){
			$CD=ch_growth($CD);
			$CF[$CD[id]]=$js_ch_num;
			#設定
			$ch_cf=array();
			$ch_cf[0]=$CD[0];		#名前
			$ch_cf[1]=$CD[1];		#B/P
			$ch_cf[2]=$CD[2];		#投
			$ch_cf[3]=$CD[3];		#打
			$ch_cf[4]=floor($CD[4]);	#調子
			$ch_cf[5]=floor($CD[5]);	#疲労
			$ch_cf[6]=$CD[6];		#画像
			$ch_cf[7]=$CD[7];		#Lv
			$ch_cf[8]=$CD[8];		#Exp
			$ch_cf[9]=floor($CD[11]);	#ミート
			$ch_cf[10]=floor($CD[12]);	#パワー
			$ch_cf[11]=floor($CD[13]);	#走力
			$ch_cf[12]=floor($CD[14]);	#肩力
			$ch_cf[13]=floor($CD[15]);	#守備力
			$ch_cf[14]=floor($CD[16]);	#反応速度
			$ch_cf[15]=floor($CD[17]);	#エラー回避
			$ch_cf[16]=$CD[20];		#フォーム
			$ch_cf[17]=floor($CD[21]);	#球速
			$ch_cf[18]=floor($CD[22]);	#コントロール
			$ch_cf[19]=floor($CD[23]);	#スタミナ
			$ch_cf[20]=floor($CD[24]);	#スライダー
			$ch_cf[21]=floor($CD[25]);	#カーブ
			$ch_cf[22]=floor($CD[26]);	#フォーク
			$ch_cf[23]=floor($CD[27]);	#シンカー
			$ch_cf[24]=floor($CD[28]);	#シュート
			$ch_cf[25]=floor($CD[31]);	#Kストレート
			$ch_cf[26]=floor($CD[32]);	#Kスライダー
			$ch_cf[27]=floor($CD[33]);	#Kカーブ
			$ch_cf[28]=floor($CD[34]);	#Kフォーク
			$ch_cf[29]=floor($CD[35]);	#Kシンカー
			$ch_cf[30]=floor($CD[36]);	#Kシュート
			$ch_cf[31]=$CD[38];		#ベンチ入り
			$ch_cf[32]=$CD[44];		#トレードロック
			$ch_cf[33]=$CD[37];		#選手等級(N,R,SR)
			$ch_cf[34]=$CD[45];		#ポイント
			#表示
			$js_list_cd.="card[$js_ch_num]=\"";
			for($i=0;$i<=34;$i++){
				if($i>=1){$js_list_cd.=' ';}
				$js_list_cd.=$ch_cf[$i];
			}
			$js_list_cd.="\";\n";
			$js_list_id.="card_id[$js_ch_num]=\"$CD[id]\";\n";
			$js_ch_num++;
		}
		$IDC[$ID]=1;
	}
}
	if($js_ch_num>0){
		#全体
$html.=<<<EOF
<script type="text/javascript">
<!--
function del_check(){
	if(confirm('このカードを破棄します、よろしいですか？')){
		return true;
	}else{
			return false;
	}
}
//CARD
card=new Array();
$js_list_cd
card_id=new Array();
$js_list_id
//ST
st=new Array();
EOF;
$html.="st[0]=\"".ch_st(1,0)."\";\n";
$html.="st[1]=\"".ch_st(11,0)."\";\n";
$html.="st[2]=\"".ch_st(21,0)."\";\n";
$html.="st[3]=\"".ch_st(31,0)."\";\n";
$html.="st[4]=\"".ch_st(41,0)."\";\n";
$html.="st[5]=\"".ch_st(51,0)."\";\n";
$html.="st[6]=\"".ch_st(61,0)."\";\n";
$html.="st[7]=\"".ch_st(71,0)."\";\n";
$html.="st[8]=\"".ch_st(81,0)."\";\n";
$html.="st[9]=\"".ch_st(91,0)."\";\n";
$html.="st[10]=\"".ch_st(101,0)."\";\n";
$html.="st[11]=\"".ch_st(111,0)."\";\n";
$html.=<<<EOF
//ST
st2=new Array();
EOF;
$html.="st2[0]=\"".ch_st(1,1)."\";\n";
$html.="st2[1]=\"".ch_st(11,1)."\";\n";
$html.="st2[2]=\"".ch_st(21,1)."\";\n";
$html.="st2[3]=\"".ch_st(31,1)."\";\n";
$html.="st2[4]=\"".ch_st(41,1)."\";\n";
$html.="st2[5]=\"".ch_st(51,1)."\";\n";
$html.="st2[6]=\"".ch_st(61,1)."\";\n";
$html.="st2[7]=\"".ch_st(71,1)."\";\n";
$html.="st2[8]=\"".ch_st(81,1)."\";\n";
$html.="st2[9]=\"".ch_st(91,1)."\";\n";
$html.="st2[10]=\"".ch_st(101,1)."\";\n";
$html.="st2[11]=\"".ch_st(111,1)."\";\n";
$html.=<<<EOF
//カードフォーカス
function card_focus(no){
	ch_d=card[no].split(" ");
	document.getElementById('ch_id').value=card_id[no];
	//PC
	document.getElementById('chP_id').innerHTML=card_id[no];
	document.getElementById('chP_NAME').innerHTML=ch_d[0];
	document.getElementById('chP_type').innerHTML=ch_d[1];
	document.getElementById('chP_PC').innerHTML=ch_d[2];
	document.getElementById('chP_img').src='$SET[dir_icon]/'+ch_d[6];
	
	chP_st=new Array();//st
	chP_st[0]=Math.floor(ch_d[17]/10);
	chP_st[1]=Math.floor(ch_d[18]/10);
	chP_st[2]=Math.floor(ch_d[19]/10);
	chP_st[3]=Math.floor(ch_d[25]/10);
	document.getElementById('cdP_SP').title=st2[chP_st[0]]+ch_d[17];
	document.getElementById('cdP_BRK0').title=ch_d[25];
	document.getElementById('cdP_C').title=ch_d[18];
	document.getElementById('cdP_S').title=ch_d[19];
	document.getElementById('chP_SP').innerHTML=parseInt(0.8576*ch_d[17]+0.08*100+3.24*(1)+76+0.5)+'km/h';
	document.getElementById('chP_BRK0').innerHTML=st[chP_st[3]];
	document.getElementById('chP_C').innerHTML=st[chP_st[1]];
	document.getElementById('chP_S').innerHTML=st[chP_st[2]];
	//フォーム
	var ch_psty;\n
EOF;
$html.="	if(ch_d[16]==0){\n";
$html.="		ch_psty='".$SET[list_pstyle][0]."';\n";
$html.="	}else if(ch_d[16]==1){\n";
$html.="		ch_psty='".$SET[list_pstyle][1]."';\n";
$html.="	}else if(ch_d[16]==2){\n";
$html.="		ch_psty='".$SET[list_pstyle][2]."';\n";
$html.="	}else if(ch_d[16]==3){\n";
$html.="		ch_psty='".$SET[list_pstyle][3]."';\n";
$html.="	}\n";
$html.="	document.getElementById('chP_psty').innerHTML=ch_psty;\n";
$html.=<<<EOF
	document.getElementById('img_BR0').title='ストレート'+st2[chP_st[0]]+ch_d[17]+'('+st2[chP_st[3]]+ch_d[25]+')';
	//BR+BRI+BRK
	ch_BR=new Array();ch_BRI=new Array();
	ch_BR[1]=Math.floor(ch_d[20]/10);ch_BRI[1]=Math.ceil(ch_d[20]/(100/7));
	ch_BR[2]=Math.floor(ch_d[21]/10);ch_BRI[2]=Math.ceil(ch_d[21]/(100/7));
	ch_BR[3]=Math.floor(ch_d[22]/10);ch_BRI[3]=Math.ceil(ch_d[22]/(100/7));
	ch_BR[4]=Math.floor(ch_d[23]/10);ch_BRI[4]=Math.ceil(ch_d[23]/(100/7));
	ch_BR[5]=Math.floor(ch_d[24]/10);ch_BRI[5]=Math.ceil(ch_d[24]/(100/7));
	ch_BRK=new Array();
	ch_BRK[1]=Math.floor(ch_d[26]/10);
	ch_BRK[2]=Math.floor(ch_d[27]/10);
	ch_BRK[3]=Math.floor(ch_d[28]/10);
	ch_BRK[4]=Math.floor(ch_d[29]/10);
	ch_BRK[5]=Math.floor(ch_d[30]/10);
	if(ch_d[2]=='R'){
		document.getElementById('img_BR1').title='スライダー'+st2[ch_BR[1]]+ch_d[20]+'('+st2[ch_BRK[1]]+ch_d[26]+')';	if(ch_d[20]==0){document.getElementById('img_BR1').title='スライダー-';}
		document.getElementById('img_BR2').title='カーブ'+st2[ch_BR[2]]+ch_d[21]+'('+st2[ch_BRK[2]]+ch_d[27]+')';		if(ch_d[21]==0){document.getElementById('img_BR2').title='カーブ-';}
		document.getElementById('img_BR3').title='フォーク'+st2[ch_BR[3]]+ch_d[22]+'('+st2[ch_BRK[3]]+ch_d[28]+')';	if(ch_d[22]==0){document.getElementById('img_BR3').title='フォーク-';}
		document.getElementById('img_BR4').title='シンカー'+st2[ch_BR[4]]+ch_d[23]+'('+st2[ch_BRK[4]]+ch_d[29]+')';	if(ch_d[23]==0){document.getElementById('img_BR4').title='シンカー-';}
		document.getElementById('img_BR5').title='シュート'+st2[ch_BR[5]]+ch_d[24]+'('+st2[ch_BRK[5]]+ch_d[30]+')';	if(ch_d[24]==0){document.getElementById('img_BR5').title='シュート-';}
		document.getElementById('chP_BR1').innerHTML=st[ch_BR[1]];if(ch_d[20]==0){document.getElementById('chP_BR1').innerHTML='-';}
		document.getElementById('chP_BR2').innerHTML=st[ch_BR[2]];if(ch_d[21]==0){document.getElementById('chP_BR2').innerHTML='-';}
		document.getElementById('chP_BR3').innerHTML=st[ch_BR[3]];if(ch_d[22]==0){document.getElementById('chP_BR3').innerHTML='-';}
		document.getElementById('chP_BR4').innerHTML=st[ch_BR[4]];if(ch_d[23]==0){document.getElementById('chP_BR4').innerHTML='-';}
		document.getElementById('chP_BR5').innerHTML=st[ch_BR[5]];if(ch_d[24]==0){document.getElementById('chP_BR5').innerHTML='-';}
		document.getElementById('img_BR1').src='$SET[dir_img]/brk1-'+ch_BRI[1]+'.png';
		document.getElementById('img_BR2').src='$SET[dir_img]/brk2-'+ch_BRI[2]+'.png';
		document.getElementById('img_BR3').src='$SET[dir_img]/brk3-'+ch_BRI[3]+'.png';
		document.getElementById('img_BR4').src='$SET[dir_img]/brk4-'+ch_BRI[4]+'.png';
		document.getElementById('img_BR5').src='$SET[dir_img]/brk5-'+ch_BRI[5]+'.png';
	}else{
		document.getElementById('img_BR5').title='スライダー'+st2[ch_BR[1]]+ch_d[20]+'('+st2[ch_BRK[1]]+ch_d[26]+')';	if(ch_d[20]==0){document.getElementById('img_BR5').title='スライダー-';}
		document.getElementById('img_BR4').title='カーブ'+st2[ch_BR[2]]+ch_d[21]+'('+st2[ch_BRK[2]]+ch_d[27]+')';		if(ch_d[21]==0){document.getElementById('img_BR4').title='カーブ-';}
		document.getElementById('img_BR3').title='フォーク'+st2[ch_BR[3]]+ch_d[22]+'('+st2[ch_BRK[3]]+ch_d[28]+')';	if(ch_d[22]==0){document.getElementById('img_BR3').title='フォーク-';}
		document.getElementById('img_BR2').title='シンカー'+st2[ch_BR[4]]+ch_d[23]+'('+st2[ch_BRK[4]]+ch_d[29]+')';	if(ch_d[23]==0){document.getElementById('img_BR2').title='シンカー-';}
		document.getElementById('img_BR1').title='シュート'+st2[ch_BR[5]]+ch_d[24]+'('+st2[ch_BRK[5]]+ch_d[30]+')';	if(ch_d[24]==0){document.getElementById('img_BR1').title='シュート-';}
		document.getElementById('chP_BR5').innerHTML=st[ch_BR[1]];if(ch_d[20]==0){document.getElementById('chP_BR5').innerHTML='-';}
		document.getElementById('chP_BR4').innerHTML=st[ch_BR[2]];if(ch_d[21]==0){document.getElementById('chP_BR4').innerHTML='-';}
		document.getElementById('chP_BR3').innerHTML=st[ch_BR[3]];if(ch_d[22]==0){document.getElementById('chP_BR3').innerHTML='-';}
		document.getElementById('chP_BR2').innerHTML=st[ch_BR[4]];if(ch_d[23]==0){document.getElementById('chP_BR2').innerHTML='-';}
		document.getElementById('chP_BR1').innerHTML=st[ch_BR[5]];if(ch_d[24]==0){document.getElementById('chP_BR1').innerHTML='-';}
		document.getElementById('img_BR5').src='$SET[dir_img]/brk5-'+ch_BRI[1]+'.png';
		document.getElementById('img_BR4').src='$SET[dir_img]/brk4-'+ch_BRI[2]+'.png';
		document.getElementById('img_BR3').src='$SET[dir_img]/brk3-'+ch_BRI[3]+'.png';
		document.getElementById('img_BR2').src='$SET[dir_img]/brk2-'+ch_BRI[4]+'.png';
		document.getElementById('img_BR1').src='$SET[dir_img]/brk1-'+ch_BRI[5]+'.png';
	}
	//BT
	document.getElementById('chB_id').innerHTML=card_id[no];
	document.getElementById('chB_NAME').innerHTML=ch_d[0];
	document.getElementById('chB_type').innerHTML=ch_d[1];
	document.getElementById('chB_PC').innerHTML=ch_d[2];
	document.getElementById('chB_BT').innerHTML=ch_d[3];
	document.getElementById('ch_LV').innerHTML=ch_d[7];
	document.getElementById('ch_PT').innerHTML=ch_d[34];
	document.getElementById('chB_img').src='$SET[dir_icon]/'+ch_d[6];
	
	chB_st=new Array();//st
	chB_st[0]=Math.floor(ch_d[9]/10);
	chB_st[1]=Math.floor(ch_d[10]/10);
	chB_st[2]=Math.floor(ch_d[11]/10);
	chB_st[3]=Math.floor(ch_d[12]/10);
	chB_st[4]=Math.floor(ch_d[13]/10);
	chB_st[5]=Math.floor(ch_d[14]/10);
	chB_st[6]=Math.floor(ch_d[15]/10);
	document.getElementById('cdB_MT').innerHTML=ch_d[9];
	document.getElementById('cdB_PW').innerHTML=ch_d[10];
	document.getElementById('cdB_SP').innerHTML=ch_d[11];
	document.getElementById('cdB_SPW').innerHTML=ch_d[12];
	document.getElementById('cdB_DF').innerHTML=ch_d[13];
	document.getElementById('cdB_BSP').innerHTML=ch_d[14];
	document.getElementById('cdB_ER').innerHTML=ch_d[15];
	document.getElementById('chB_MT').innerHTML=st[chB_st[0]];
	document.getElementById('chB_PW').innerHTML=st[chB_st[1]];
	document.getElementById('chB_SP').innerHTML=st[chB_st[2]];
	document.getElementById('chB_SPW').innerHTML=st[chB_st[3]];
	document.getElementById('chB_DF').innerHTML=st[chB_st[4]];
	document.getElementById('chB_BSP').innerHTML=st[chB_st[5]];
	document.getElementById('chB_ER').innerHTML=st[chB_st[6]];
	//レア度・調子・疲労計算
	var ch_rare,ch_tone,ch_fati;\n
EOF;
$html.="	if(ch_d[33]=='N'){\n";
$html.="		ch_rare='".$SET[list_grade][N]."';\n";
$html.="	}else if(ch_d[33]=='R'){\n";
$html.="		ch_rare='".$SET[list_grade][R]."';\n";
$html.="	}else if(ch_d[33]=='HR'){\n";
$html.="		ch_rare='".$SET[list_grade][HR]."';\n";
$html.="	}else if(ch_d[33]=='SR'){\n";
$html.="		ch_rare='".$SET[list_grade][SR]."';\n";
$html.="	}\n";
$html.="	document.getElementById('chB_rare').innerHTML=ch_rare;\n";
$html.="	if(ch_d[4]>=80){\n";
$html.="		ch_tone='".ch_tone(80)."';\n";
$html.="	}else if(ch_d[4]>=60){\n";
$html.="		ch_tone='".ch_tone(60)."';\n";
$html.="	}else if(ch_d[4]>=40){\n";
$html.="		ch_tone='".ch_tone(40)."';\n";
$html.="	}else if(ch_d[4]>=20){\n";
$html.="		ch_tone='".ch_tone(20)."';\n";
$html.="	}else if(ch_d[4]>=0){\n";
$html.="		ch_tone='".ch_tone(0)."';\n";
$html.="	}else{\n";
$html.="		ch_tone='".ch_tone(-1)."';\n";
$html.="	}\n";
$html.=<<<EOF
	document.getElementById('chB_tone').innerHTML=ch_tone;
	document.getElementById('chP_tone').innerHTML=ch_tone;\n
EOF;
$html.="	if(ch_d[5]>=80){\n";
$html.="		ch_fati='".ch_fati(80)."';\n";
$html.="	}else if(ch_d[5]>=60){\n";
$html.="		ch_fati='".ch_fati(60)."';\n";
$html.="	}else if(ch_d[5]>=40){\n";
$html.="		ch_fati='".ch_fati(40)."';\n";
$html.="	}else if(ch_d[5]>=20){\n";
$html.="		ch_fati='".ch_fati(20)."';\n";
$html.="	}else if(ch_d[5]>=0){\n";
$html.="		ch_fati='".ch_fati(0)."';\n";
$html.="	}else{\n";
$html.="		ch_fati='".ch_fati(-1)."';\n";
$html.="	}\n";
$html.=<<<EOF
	document.getElementById('chB_fati').innerHTML=ch_fati;
	document.getElementById('chP_fati').innerHTML=ch_fati;
	//PorB
	if(ch_d[1] == 'P'){
		document.getElementById('P').style.display='block';
		document.getElementById('B').style.display='none';
	}else{
		document.getElementById('B').style.display='block';
		document.getElementById('P').style.display='none';
	}
	//delbt
	if((ch_d[31]==""||ch_d[31]==0)&&(ch_d[32]==""||ch_d[32]==0)){
		document.getElementById('delbt').style.display='block';
	}else{
		document.getElementById('delbt').style.display='none';
	}
	//XY
	var obj=new Object();
	obj.x=document.documentElement.scrollLeft || document.body.scrollLeft;
	obj.y=document.documentElement.scrollTop || document.body.scrollTop;
	document.getElementById('card_focus').style.left=obj.x+200;
	document.getElementById('card_focus').style.top=obj.y+100;
	document.getElementById('card_focus').style.display='block';
}
function card_focus_no(){
	document.getElementById('card_focus').style.display='none';
}
//-->
</script>
<div id="card_focus" style="position:absolute;z-index:1;display:none;">
<table><form method=POST name="form" action="$SET[path_index]" target="_blank"><tr><td>
<input type=submit value="カード詳細" style="width:153px;border:1px solid gray;" onclick="r.value='card_detail';"><input type=button value="×" style="width:30px;border:1px solid gray;" onclick="card_focus_no();"><br>
<table id='B' style="width:183px;height:251px;border:0px;background-image:url('$SET[dir_img]/card_bg_bt.png');font-family:Arial,'ＭＳ Ｐゴシック',sans-serif;font-size:16px;display:$CH_B;" onclick="document.getElementById('P').style.display='block';this.style.display='none';">
<tr style="height:24px;"><td style="font-size:16px;text-align:center;font-weight:bold;" colspan=5><span id="chB_NAME"></span></td><td style="width:48px;text-align:center;" colspan=2><span id="chB_tone"></span><span id="chB_fati"></span></td></tr>
<tr style="text-align:center;"><td style="text-align:center;vertical-align:middle;" colspan=4 rowspan=4>
<img id="chB_img" style="height:$SET[icon_h]px;" alt="image">
</td><td style="height:21px;font-size:10px;" title="カードの等級">R</td><td colspan=2 style="font-size:11px;"><span id="chB_rare"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="利き腕">投</td><td style="font-size:11px;" colspan=2><span id="chB_PC"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="打席">打</td><td style="font-size:11px;" colspan=2><span id="chB_BT"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="レベル">Lv</td><td style="font-size:11px;" colspan=2><span id="ch_LV"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" colspan=4>特能：-</td><td title="ステータスポイント">P</td><td style="font-size:11px;" colspan=2><span id="ch_PT"></span></td></tr>
<tr style="height:21px;text-align:center;font-size:12px;"><td style="width:22px;" title="ミートさせる技術">巧</td><td style="width:22px;" title="打球を遠くへ飛ばす力">力</td><td style="width:22px;" title="足の速さ">走</td><td style="width:22px;" title="守備時の肩の強さ">肩</td><td style="width:21px;" title="守備の上手さ">守</td><td style="width:22px;" title="打球・投球に対する反応速度">反</td><td style="width:22px;" title="エラー発生率の低さ">E避</td></tr>
<tr style="height:23px;text-align:center;font-size:15px;"><td><span id="chB_MT"></span></td><td><span id="chB_PW"></span></td><td><span id="chB_SP"></span></td><td><span id="chB_SPW"></span></td><td><span id="chB_DF"></span></td><td><span id="chB_BSP"></span></td><td><span id="chB_ER"></span></td></tr>
<tr style="height:20px;text-align:center;font-size:10px;"><td><span id="cdB_MT"></span></td><td><span id="cdB_PW"></span></td><td><span id="cdB_SP"></span></td><td><span id="cdB_SPW"></span></td><td><span id="cdB_DF"></span></td><td><span id="cdB_BSP"></span></td><td><span id="cdB_ER"></span></td></tr>
<tr style="height:19px;font-size:8px;text-align:center;"><td colspan=7>&nbsp;</td></tr>
<tr style="font-size:9px;text-align:center;"><td colspan=7>ID:<span id="chB_id"></span>(<span id="chB_type"></span>)</td></tr>
</table>
<table id='P' style="width:183px;height:251px;border:0px;background-image:url('$SET[dir_img]/card_bg_pc.png');font-family:Arial,'ＭＳ Ｐゴシック',sans-serif;font-size:16px;display:$CH_P;" onclick="document.getElementById('B').style.display='block';this.style.display='none';">
<tr style="height:24px;"><td style="font-size:16px;text-align:center;font-weight:bold;" colspan=2><span id="chP_NAME"></span></td><td style="width:48px;text-align:center;"><span id="chP_tone"></span><span id="chP_fati"></td></tr>
<tr style="text-align:center;"><td style="text-align:center;vertical-align:middle;width:100px;" rowspan=4>
<img id="chP_img" style="height:$SET[icon_h]px;" alt="image">
</td><td style="width:21px;font-size:10px;" title="利き腕">投</td><td style="height:21px;font-size:11px;"><span id="chP_PC"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="球速">速</td><td style="font-size:11px;" id="cdP_SP"><span id="chP_SP"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="速球キレ">速K</td><td style="font-size:11px;" id="cdP_BRK0"><span id="chP_BRK0"></span></td></tr>
<tr style="font-size:10px;text-align:center;"><td style="height:21px;" title="コントロール">制</td><td style="font-size:11px;" id="cdP_C"><span id="chP_C"></span></td></tr>
<tr style="font-size:9px;text-align:center;"><td style="height:21px;"><span id="chP_psty"></span></td><td title="スタミナ">体</td><td style="font-size:11px;" id="cdP_S"><span id="chP_S"></span></td></tr>
<tr style="height:89px;text-align:center;font-size:9px;vertical-align:middle;"><td colspan=3>
<table style="text-align:center;font-size:11px;" align=center><tr style="vertical-align:top;">
<td rowspan=2 style="width:25px;"><span id="chP_BR1"></span></td>
<td><img id="img_BR1" style="width:44px;height:10px;" alt='BR1'></td>
<td><img id="img_BR0" style="width:10px;height:10px;" alt='BR0' src='./img/brk0.png'></td>
<td><img id="img_BR5" style="width:44px;height:10px;" alt='BR5'></td>
<td rowspan=2 style="width:25px;"><span id="chP_BR5"></span></td>
</tr><tr>
<td><img id="img_BR2" style="width:44px;height:44px;" alt='BR2'></td>
<td><img id="img_BR3" style="width:10px;height:44px;" alt='BR3'></td>
<td><img id="img_BR4" style="width:44px;height:44px;" alt='BR4'></td>
</tr><tr>
<td><span id="chP_BR2"></span></td><td></td><td><span id="chP_BR3"></span></td><td></td><td><span id="chP_BR4"></span></td>
</tr></table>
</td></tr>
<tr style="font-size:9px;text-align:center;"><td colspan=3>ID:<span id="chP_id"></span>(<span id="chP_type"></span>)</td></tr>
</table>
<input id="delbt" type=submit value="カード破棄" style="width:183px;border:1px solid gray;" onclick="r.value='card_del';return del_check();">
</td></tr>
<input type=hidden name=r>
<input type=hidden name=ch id=ch_id>
</form></table>
</div>
EOF;
		#
		return $html;
	}
}
#----------------------------------------------------------#
# TIME更新
#----------------------------------------------------------#
function refresh_time(){
global$SET,$TIME,$disp;

$db=sql_open();
	$TIME=read_dataL('time','time');
	if($TIME[no]==0){
		$TIME[no]=1;
		$TIME[num]=0;
		$TIME[time]=time();
		update('time','time',$TIME);
		refresh_player();
	}else{
		$D[time]=time()-$TIME[time];
		#更新
		$D[check]=0;$D[checkR]=0;
		while($D[check]<=10){
			if($SET[gm_num_max]>$TIME[num]){	#シーズン中(MAX>現行)
				#更新
				if($D[time]>=$SET[gm_itv]){
					$TIME[time]+=$SET[gm_itv];
					$D[time]-=$SET[gm_itv];
					$TIME[num]++;
				}else{
					break;
				}
			}else{#シーズン更新待ち
				#更新
				if($D[time]>=$SET[gm_vac]){
					$TIME[time]+=$SET[gm_vac];
					$D[time]-=$SET[gm_vac];
					$D[checkR]=1;
					$D[check]++;
					break;
				}else{
					break;
				}
			}
			$D[check]++;
		}
		#
		if($D[checkR]){
			#新聞更新
			read_file('./r/team_rank.php');
			team_rank_htmlR();
			#------------------------------#
			#試合HTML/データ削除
			#------------------------------#
			$sql=mysql_query("SELECT * FROM game");
			while($GAME=mysql_fetch_assoc($sql)){
				$filename='game'.$GAME[id].'.html';
				if(file_exists($filename)){
					unlink($filename);
				}
			mysql_query("DELETE FROM game WHERE id='$GAME[id]'");
			}
			#------------------------------#
			$TIME[no]++;
			$TIME[num]=1;
			refresh_player();
			read_file('./r/refresh_html.php');
			refresh_htmlR();
			disp($disp);
		}
		#更新チェック
		if($D[check]>=1){
			update('time','time',$TIME);
		}
		#
		if($D[checkR]){
			exit();
		}
	}
sql_close($db);
}
#----------------------------------------------------------#
# 勝敗リセット
#----------------------------------------------------------#
function refresh_player(){
	$sql=mysql_query("SELECT * FROM player FOR UPDATE");
	if($sql){
		while($OL=mysql_fetch_assoc($sql)){
			$OTM=read_dataL('team',$OL[id]);
			$OTM[0]=time();
			$OTM[1]='';
			$OTM[2]=0;
			$OTM[3]=0;
			$OTM[4]=0;
			$OTM[5]=0;
			$OTM[6]=0;
			$OTM[7]=0;
			update('team',$OL[id],$OTM);
			$OL[7]=0;
			update('player',$OL[id],$OL);
		}
	}
}
#----------------------------------------------------------#
# 配列セット
#----------------------------------------------------------#
function set_array($array,$dm,$num){
	#配列数
	if($num){
		$array_num=$num;
	}else{
		$array_num=count($array);
	}
	#配列方法
	if(!$dm){$dm='!';}
	#配列出力
	for($i=0;$i<=($array_num-1);$i++){
		if($i>=1){
			$html.=$dm;
		}
		$html.=$array[$i];
	}
	return $html;
}
#----------------------------------------------------------#
# 回数表示
#----------------------------------------------------------#
function set_selnum($num,$val){
if(!$num){$num=9;}

for($i=1;$i<=$num;$i++){
	if($val==$i&&$i){
		$html.="<option value='$i' selected>$i";
	}else{
		$html.="<option value='$i'>$i";
	}
}
return $html;
}
#----------------------------------------------------------#
# 時間(時、分、秒)表示
#----------------------------------------------------------#
function html_time($time,$type){
if($type==1){
	$D_TIME=localtime($time,TRUE);
	$weekly=array('日','月','火','水','木','金','土');
	$D_TIME[tm_year]+=1900;
	$D_TIME[tm_mon]++;
	$html="$D_TIME[tm_mon]月$D_TIME[tm_mday]日(".$weekly[$D_TIME[tm_wday]].")&nbsp;$D_TIME[tm_hour]:$D_TIME[tm_min]:$D_TIME[tm_sec]";
}elseif($type==2){
	$D_TIME=localtime($time,TRUE);
	$D_TIME[tm_mon]++;
	$html="$D_TIME[tm_mon]/$D_TIME[tm_mday]&nbsp;$D_TIME[tm_hour]:$D_TIME[tm_min]:$D_TIME[tm_sec]";
}elseif($type==3){
	if($time){
		if(floor($time/60)>=1){	#分以上
			if(floor($time/3600)>=1){	#時
				$html=floor($time/3600).'時間'.floor(($time%3600)/60).'分';
			}else{	#分
				$html=floor($time/60).'分';
			}
		}else{	#秒
			$html=$time.'秒';
		}
	}
}
return $html;
}
#----------------------------------------------------------#
# 調子での能力変動
#----------------------------------------------------------#
function ch_tone_set($CD){
#関数設定
$D[tone_cf]=$CD[4]*0.2-10;
$D[tone_cf2]=$CD[4]*0.1-5;
#野手
$CD[11]+=$D[tone_cf];
$CD[12]+=$D[tone_cf];
$CD[13]+=$D[tone_cf2];
$CD[14]+=$D[tone_cf2];
$CD[15]+=$D[tone_cf2];
$CD[16]+=$D[tone_cf];
$CD[17]+=$D[tone_cf];
#投手
$CD[21]+=$D[tone_cf2];
$CD[31]+=$D[tone_cf];
$CD[22]+=$D[tone_cf];
$CD[23]+=$D[tone_cf];
if($CD[24]>0){$CD[24]+=$D[tone_cf];$CD[32]+=$D[tone_cf];}
if($CD[25]>0){$CD[25]+=$D[tone_cf];$CD[33]+=$D[tone_cf];}
if($CD[26]>0){$CD[26]+=$D[tone_cf];$CD[34]+=$D[tone_cf];}
if($CD[27]>0){$CD[27]+=$D[tone_cf];$CD[35]+=$D[tone_cf];}
if($CD[28]>0){$CD[28]+=$D[tone_cf];$CD[36]+=$D[tone_cf];}
#出力
return $CD;
}
#----------------------------------------------------------#
# 順位表示
#----------------------------------------------------------#
function set_rank($ID){
$PL=read_data('player',$ID);
$TM=read_data('team',$ID);

return $PL[20].'部リーグ';
}
#----------------------------------------------------------#
# BRK
#----------------------------------------------------------#
function ch_brk($val,$type){
if($type){
	switch($type){
		case 1:
		$html=$val*0.22-25;
		break;
		case 2:
		$html=$val*0.31-40;
		break;
		case 3:
		$html=$val*0.25-30;
		break;
		case 4:
		$html=$val*0.25-30;
		break;
		case 5:
		$html=$val*0.20-20;
		break;
		default:
		$html=0;
	}
	return $html;
}
}
#----------------------------------------------------------#
# 配列設定
#----------------------------------------------------------#
function SET_STR_AR($AR,$VAL,$KEY,$COM){
	if($AR["$VAL"]){
		$AR["$VAL"].=$COM.$KEY;
	}else{
		$AR["$VAL"]=$KEY;
	}
return $AR["$VAL"];
}
#----------------------------------------------------------#
# スマートフォン判定
#----------------------------------------------------------#
function is_mobile(){
$useragents = array(
'iPhone', // Apple iPhone
'iPod', // Apple iPod touch
'Android', // 1.5+ Android
'dream', // Pre 1.5 Android
'CUPCAKE', // 1.5+ Android
'blackberry9500', // Storm
'blackberry9530', // Storm
'blackberry9520', // Storm v2
'blackberry9550', // Storm v2
'blackberry9800', // Torch
'webOS', // Palm Pre Experimental
'incognito', // Other iPhone browser
'webmate' // Other iPhone browser
);
$pattern = '/'.implode('|', $useragents).'/i';
return preg_match($pattern, $_SERVER['HTTP_USER_AGENT']);
}
#----------------------------------------------------------#
# クッキー設定
#----------------------------------------------------------#
function set_cookie($id,$pass){
	$D[CKTIME]=time()+60*60*24*30;
	setcookie("id",$id,$D[CKTIME]);
	setcookie("pass",$pass,$D[CKTIME]);
}
#----------------------------------------------------------#
# クッキー削除
#----------------------------------------------------------#
function del_cookie(){
	setcookie("id",null,-1);
	setcookie("pass",null,-1);
}
#----------------------------------------------------------#
# ログ取得
#----------------------------------------------------------#
function save_log(){
global $Q,$SET,$disp;
	#SQL OPEN
	$db=sql_open();
	# log
	$LOG=array();
	$LOG[time]=time();
	if(!$_COOKIE[id]){
		$LOG[id]=$_SERVER["REMOTE_ADDR"];
	}else{
		$LOG[id]=$_COOKIE[id];
	}
	$LOG[r]=$Q[r];
	if(!$LOG[r]){$LOG[r]='index';}
	$LOG[q]='';
	if(count($Q)>0){
		foreach($Q as $key=>$val){
			if($LOG[q]){$LOG[q].="&";}
			$LOG[q].="$key=$val";
		}
	}
	if(!data_check('log','time',$LOG[time])){
		$LOG_COL=insert_colum($LOG);
		$LOG_DATA=insert_data($LOG);
		mysql_query("INSERT INTO log $LOG_COL VALUES $LOG_DATA",$db);
	}
	#analysis
	$ANA[id]=$LOG[id];
	$D[check_field]=$LOG[r];
	
	$D[field_sql]=mysql_query("SELECT * FROM analysis",$db);
	$D[field_num]=mysql_num_fields($D[field_sql]);
	$D[field_ch]=0;
	for($i=0;$i<$D[field_num];$i++){
		if($D[check_field]==mysql_field_name($D[field_sql],$i)){
			$D[field_ch]=1;
			break;
		}
	}
	
	if(!$D[field_ch]){
		mysql_query("ALTER TABLE analysis ADD $D[check_field] INT",$db);
	}
	if(!data_check('analysis','id',$ANA[id])){
		$ANA_COL=insert_colum($ANA);
		$ANA_DATA=insert_data($ANA);
		mysql_query("INSERT INTO analysis $ANA_COL VALUES $ANA_DATA",$db);
	}
	$ANA=mysql_fetch_assoc(mysql_query("SELECT * FROM analysis WHERE id='$ANA[id]'"));
	if(!$ANA[$D[check_field]]){
		$ANA[$D[check_field]]=1;
	}else{
		$ANA[$D[check_field]]++;
	}
	update('analysis',$ANA[id],$ANA);
	#SQL CLOSE
	sql_close($db);
}
#----------------------------------------------------------#
?>
